setwd("<your directory or folder path>")

#
#
#
# N = n.good + n.bad
N <- 1000
# p = n.good / (n.good + n.bad)
Xc <- 86
samp.size <- 100
Xcrit <- seq(from=75,to=samp.size,by=1)
pmass <- dbinom(Xcrit,size=samp.size,prob=0.95)
#attach(df1)
alpha <- 0.05
p <- seq(from=0.60,to=0.999,by=0.001)
n.good <- floor(p*N)
n.bad <- N - n.good
prob.binom <- 1-pbinom(Xc-1,size=samp.size,prob=p) 
prob.hyper <- 1 - phyper(Xc-1,m=n.good,n=n.bad,k=samp.size)
plot(p,prob.binom,type="b",main="Power (OC) Curves",xlab="p=Pr{K <= k}",ylab="Pr{PASS|p,n,k}",pch=1,col=1)
points(x=p,y=prob.hyper,pch=2,col=2)
abline(v=0.90)
abline(h=0.95)
abline(h=0.10)
text(x=0.65,y=0.925,"95% Power")
text(x=0.82,y=.925,"p=0.90")
legend(x=0.70,y=0.60,legend=c("binomial","hypergeometric"),pch=c(1,2),col=c(1,2))
dev.new()

plot(Xcrit,pmass,type="h",xaxp=c(70,100,10),main="Binomial Probability Mass Function")

probfail <- 1 - probpass
df2 <- cbind(samp.size,N,p,Xc,prob.binom,prob.hyper)

write.csv(df2,"20180112 Attribute OC Curve No to Pass Outputs.csv")